<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface SupplyDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Supply 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param supply primary key
 	 */
	public function delete($supplyid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Supply supply
 	 */
	public function insert($supply);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Supply supply
 	 */
	public function update($supply);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySupplyvalue($value);

	public function queryBySupplycomment($value);

	public function queryByCurrentdate($value);

	public function queryByTempdelete($value);


	public function deleteBySupplyvalue($value);

	public function deleteBySupplycomment($value);

	public function deleteByCurrentdate($value);

	public function deleteByTempdelete($value);


}
?>